uniform mat4 uniform_mtx4_wvp;
uniform mat4 uniform_mtx4_w;
uniform mat4 uniform_mtx4_array[40];

attribute vec3 attrib_position;
attribute vec3 attrib_normal;
attribute vec4 attrib_colour;
attribute vec2 attrib_uv;
attribute vec4 attrib_weights;
attribute vec4 attrib_joints;


varying vec4 v_colour;
varying vec3 v_normal;
varying vec2 v_uv;


void main()
{
    vec3 oPosition;
    vec3 oNormal;
    
    vec3 nrm = attrib_normal;
    nrm.y = -nrm.y;
              
    oPosition = ((uniform_mtx4_array[int(attrib_joints.x)]*vec4(attrib_position,1.0)).xyz) * attrib_weights.xxx;
    oNormal   = (mat3(uniform_mtx4_array[int(attrib_joints.x)])*nrm) * attrib_weights.xxx;   
   
    oPosition += ((uniform_mtx4_array[int(attrib_joints.y)]*vec4(attrib_position,1.0)).xyz) * attrib_weights.yyy;
    oNormal   += (mat3(uniform_mtx4_array[int(attrib_joints.y)])*nrm) * attrib_weights.yyy;   
         
    oPosition += ((uniform_mtx4_array[int(attrib_joints.z)]*vec4(attrib_position,1.0)).xyz) * attrib_weights.zzz;
    oNormal   += (mat3(uniform_mtx4_array[int(attrib_joints.z)])*nrm) * attrib_weights.zzz;   
      
    oPosition += ((uniform_mtx4_array[int(attrib_joints.w)]*vec4(attrib_position,1.0)).xyz) * attrib_weights.www;
    oNormal   += (mat3(uniform_mtx4_array[int(attrib_joints.w)])*nrm) * attrib_weights.www;
    oNormal    = normalize(oNormal);
    
    oNormal.y = -oNormal.y;
    
    gl_Position = uniform_mtx4_wvp * vec4(oPosition,1.0);
    v_colour    = attrib_colour;
    v_uv        = attrib_uv;
    v_normal    = normalize(mat3(uniform_mtx4_w)*oNormal.xyz);
    v_normal    = normalize(vec4(vec4(oNormal,0.0)*uniform_mtx4_w).xyz);
}